% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-assignSubtypes.R
\name{assignSubtypes,CohortList,list-method}
\alias{assignSubtypes,CohortList,list-method}
\title{Assign Subtype Annotations to a SurvivalExperiment Object}
\usage{
\S4method{assignSubtypes}{CohortList,list}(
  object,
  subtypes,
  ...,
  sampleCol = "sample_name",
  subtypeCol = "subtype"
)
}
\arguments{
\item{object}{A \code{CohortList}.}

\item{subtypes}{A \code{list} of \code{data.frame} objects, one per cohort, with
to subtypes to assign to the colData slot of cohorts with a matching name.}

\item{...}{Catch unnamed parameters. Not used.}

\item{sampleCol}{A \code{character} vector indicating the name of the colum with
sample identifiers in the subtype column. Must match the name of the
sample identifier in colData.}

\item{subtypeCol}{A \code{character} vectoring indicating the name of the column
with the subtype labels in the \code{subtypes} \code{data.frame}.}
}
\value{
The \code{CohortList} with the subtypes in the \code{subtypes} column
of the colData slot and a metadata item, \code{hasSubtypes}, set to TRUE for
each \code{SurvivalExperiment}.
}
\description{
Assign Subtype Annotations to a SurvivalExperiment Object
}
\examples{
data(sampleCohortList)
data(cohortSubtypeDFs)

cohortList <- assignSubtypes(sampleCohortList,
  subtypes=cohortSubtypeDFs[names(sampleCohortList)],
  sampleCol='sample_name',
  subtypeCol='subtype')

}
