% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-SurvivalModel.R
\name{SurvivalModel}
\alias{SurvivalModel}
\title{Constructor for a SurvivalModel Object.}
\usage{
SurvivalModel(trainCohorts, minDaysSurvived = 365, ..., randomSeed)
}
\arguments{
\item{trainCohorts}{A 'SurvivelExperiment' containing training data for
the \code{SurvivalModel} object.}

\item{minDaysSurvived}{An \code{integer} minimum number of days survived to be
classified as a 'good' prognosis.}

\item{...}{Force subsequent parameters to be named. Not used.}

\item{randomSeed}{An \code{integer} randomSeed that was used to train the model.
Users should specify this when initializing a model to ensure
reproducibilty.}
}
\value{
A \code{SurvivalModel} object.
}
\description{
Constructor for a SurvivalModel Object.
}
\examples{
data(sampleICGCmicro)
set.seed(1987)
survModel <- SurvivalModel(sampleICGCmicro, minDaysSurvived=365,
  randomSeed=1987)

}
