% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpSetCompSummary.R
\name{hpSetCompSummary}
\alias{hpSetCompSummary}
\title{Global semantic similarity between 2 HP sets}
\usage{
hpSetCompSummary(hpSetComp, method = c("bma", "bm", "average"),
  direction = c("symSim", "r", "c"))
}
\arguments{
\item{hpSetComp}{a matrix of semantic similarities between couples
of HP terms}

\item{method}{"bma" (Best Match Average): the average of the best
matches on rows or columns (see direction param).
"bm": the maximum value. "average": the average of the whole matrix.}

\item{direction}{taken into account only if method="bma".
"r": best match per row. "c": best match per column.
"symSim" (symmetric semantic similarity): average of calls with "r" and "c"}
}
\value{
A numeric value corresponding to the semantic similarity of
the 2 HP sets
}
\description{
This function summarize the comparison of 2 sets of HP terms
}
\examples{
## Prerequisite
data(geneByHp, hp_descendants, package="PCAN")
geneByHp <- unstack(geneByHp, entrez~hp)
ic <- computeHpIC(geneByHp, hp_descendants)

###########################################
## Use case: comparing a gene and a disease
data(traitDef, geneDef, hp_ancestors, hpDef, package="PCAN")
omim <- "612285"
traitDef[which(traitDef$id==omim),]
entrez <- "57545"
geneDef[which(geneDef$entrez==entrez),]
## Get HP terms associated to the disease
data(hpByTrait, package="PCAN")
hpOfInterest <- hpByTrait$hp[which(hpByTrait$id==omim)]

## Get HP terms associated to the gene
hpByGene <- unstack(stack(geneByHp), ind~values)
geneHps <- hpByGene[[entrez]]
## Comparison of the two sets of HP terms
compMat <- compareHPSets(
    hpSet1=geneHps, hpSet2=hpOfInterest,
    IC=ic,
    ancestors=hp_ancestors,
    method="Resnik",
    BPPARAM=SerialParam()
)
## Get the symmetric semantic similarity score
hpSetCompSummary(compMat, method="bma", direction="symSim")
bm <- hpSetCompBestMatch(compMat, "b")
hpDef[match(c(bm$compared, bm$candidate), hpDef$id),]
}
\author{
Patrice Godard
}
\seealso{
\code{\link{compareHPSets}}
}

