% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{geneByHp}
\alias{geneByHp}
\title{Entrez gene IDs associated to HP terms (Example data)}
\format{A data frame with 67989 rows and 2 columns:
\describe{
\item{entrez}{entrez gene IDs}
\item{hp}{HP terms}
}}
\source{
Two ressources were used in May 27 2015: \itemize{
\item{
\url{ftp://ftp.ncbi.nlm.nih.gov/pub/clinvar/xml/ClinVarFullRelease_2015-05.xml.gz}
was used to find genes associated to each OMIM disease with a
"Pathogenic" clinical status and one of the follwing
origins: "germline", "de novo", "inherited", "maternal",
"paternal", "biparental", "uniparental".}
\item{
\url{http://compbio.charite.de/hudson/job/hpo.annotations/1039/artifact/misc/phenotype_annotation.tab}
} was used to find HP associated to each OMIM disease.
}
}
\description{
Each entrez gene IDs is associated to one or several
HP terms
}
\details{
These data are used to examplify the different functions of
the package.
More data are available in the MultiHumanPhenoDB package.
}
\examples{
###########################################
## Compute information content of each HP according to associated genes
data(geneByHp, hp_descendants, package="PCAN")
geneByHp <- unstack(geneByHp, entrez~hp)
ic <- computeHpIC(geneByHp, hp_descendants)
hist(
    ic,
    breaks=100, col="grey",
    main="Distribution of Information Content",
    xlab="IC base on genes associated to HP"
)
}

