% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeHpIC.R
\name{computeHpIC}
\alias{computeHpIC}
\title{Compute Information Content (IC) for each HP based on genes by HP}
\usage{
computeHpIC(content, hp.descendants)
}
\arguments{
\item{content}{a list providing the content associated to each HP}

\item{hp.descendants}{a list providing for each HP all its descendant
HP terms}
}
\value{
a vector of IC named with HP terms
}
\description{
Compute Information Content (IC) for each HP based on genes by HP
}
\details{
This function assumes that all the HP terms taken into account
belong to the same family of terms(i.e they are all descendants of the
same term).
}
\examples{
###########################################
## Compute information content of each HP according to associated genes
data(geneByHp, hp_descendants, package="PCAN")
geneByHp <- unstack(geneByHp, entrez~hp)
ic <- computeHpIC(geneByHp, hp_descendants)
hist(
    ic,
    breaks=100, col="grey",
    main="Distribution of Information Content",
    xlab="IC base on genes associated to HP"
)
}

