% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_GWAS_data.R
\name{load_GWAS_data}
\alias{load_GWAS_data}
\title{Load GWAS data}
\usage{
load_GWAS_data(
  association_file,
  effects_file,
  association_columns = c("Trait", "Marker", "Locus", "Site", "p", "marker_R2"),
  effects_columns = c("Trait", "Marker", "Locus", "Site", "Effect")
)
}
\arguments{
\item{association_file}{The association file}

\item{effects_file}{The effects file}

\item{association_columns}{The names of the columns in your association data
for Trait, Marker, Chromosome, Site, F, p, and marker_Rsquared}

\item{effects_columns}{The names of the columns in your effects data for
Trait, Marker, Chromosome, Site, and effect}
}
\value{
The association data and the effects data merged into a dataframe
  with one row for each SNP
}
\description{
Load GWAS data
}
\examples{
demo_association_file = system.file("extdata", "association.txt.xz",
  package = "PAST", mustWork = TRUE)
demo_effects_file = system.file("extdata", "effects.txt.xz",
  package = "PAST", mustWork = TRUE)
gwas_data <- load_GWAS_data(demo_association_file, demo_effects_file)
}
