% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_interactions.R
\name{print_path_es}
\alias{print_path_es}
\title{Prints network paths in an edge sequence}
\usage{
print_path_es(edges, G)
}
\arguments{
\item{edges}{An igraph edge sequence object.}

\item{G}{igraph object (from ptms or any interaction dataset)}
}
\value{
Returns `NULL`.
}
\description{
Pretty prints the interactions in a path.
}
\examples{
interactions <- omnipath(resources = "SignaLink3")
OPI_g <- interaction_graph(interactions = interactions)
print_path_es(
    igraph::shortest_paths(
        OPI_g,
        from = 'TYRO3',
        to = 'STAT3',
        output = 'epath'
    )$epath[[1]],
    OPI_g
)

}
\seealso{
\itemize{
    \item{\code{\link{print_path_vs}}}
}
}
