% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_interactions.R
\name{print_interactions}
\alias{print_interactions}
\title{Print OmniPath interactions}
\usage{
print_interactions(interactions, refs = FALSE)
}
\arguments{
\item{interactions}{Data frame with the interactions generated by any of the
functions in \code{\link{omnipath-interactions}}.}

\item{refs}{Logical: include PubMed IDs where available.}
}
\value{
Returns `NULL`.
}
\description{
Prints the interactions or enzyme-substrate relationships in a nice format.
}
\examples{
enzsub <- enzyme_substrate()
print_interactions(head(enzsub))
print_interactions(tail(enzsub), refs = TRUE)
print_interactions(
    dplyr::filter(
        enzsub,
        enzyme_genesymbol == 'MAP2K1',
        substrate_genesymbol == 'MAPK3'
    )
)

signor <- omnipath(resources = "SIGNOR")
print_interactions(head(signor))
#            source interaction            target n_resources
# 6 MAPK14 (Q16539)  ==( + )==> MAPKAPK2 (P49137)          23
# 4  TRPM7 (Q96QT4)  ==( + )==>    ANXA1 (P04083)          10
# 1  PRKG1 (Q13976)  ==( - )==>    TRPC3 (Q13507)           8
# 2  PTPN1 (P18031)  ==( - )==>    TRPV6 (Q9H1D0)           6
# 5 PRKACA (P17612)  ==( - )==>   MCOLN1 (Q9GZU1)           6
# 3  RACK1 (P63244)  ==( - )==>    TRPM6 (Q9BX84)           2
}
