% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{ontology_ensure_name}
\alias{ontology_ensure_name}
\title{Only ontology term names}
\usage{
ontology_ensure_name(terms, db_key = "go_basic")
}
\arguments{
\item{terms}{Character: ontology IDs or term names.}

\item{db_key}{Character: key to identify the ontology database. For the
available keys see \code{\link{omnipath_show_db}}.}
}
\value{
Character vector of ontology term names.
}
\description{
Converts a mixture of ontology IDs and names to only names. If an element
of the input is missing from the chosen ontology it will be dropped.
This can happen if the ontology is a subset (slim) version, but also if
the input is not a valid ID or name.
}
\examples{
ontology_ensure_name(c('reproduction', 'GO:0001754', 'foo bar'))
# [1] "eye photoreceptor cell differentiation" "reproduction"

}
