% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercell.R
\name{intercell_consensus_filter}
\alias{intercell_consensus_filter}
\title{Quality filter for intercell annotations}
\usage{
intercell_consensus_filter(
  data,
  percentile = NULL,
  loc_percentile = NULL,
  topology = NULL
)
}
\arguments{
\item{data}{A data frame with intercell annotations, as provided by
\code{\link{intercell}}.}

\item{percentile}{Numeric: a percentile cut off for the consensus score
of composite categories. The consensus score is the number of
resources supporting the classification of an entity into a category
based on combined information of many resources. Here you can apply
a cut-off, keeping only the annotations supported by a higher number
of resources than a certain percentile of each category. If
\code{NULL} no filtering will be performed. The value is either in the
0-1 range, or will be divided by 100 if greater than 1. The
percentiles will be calculated against the generic composite
categories and then will be applied to their resource specific
annotations and specific child categories.}

\item{loc_percentile}{Numeric: similar to \code{percentile} for major
localizations. For example, with a value of 50, the secreted, plasma
membrane transmembrane or peripheral attributes will be \code{TRUE}
only where at least 50 percent of the resources support these.}

\item{topology}{Character vector: list of allowed topologies, possible
values are *"secreted"*, *"plasma_membrane_peripheral"* and
*"plasma_membrane_transmembrane"*.}
}
\value{
The data frame in \code{data} filtered by the consensus scores.
}
\description{
Quality filter for intercell annotations
}
\examples{
ligand_receptor <- intercell(parent = c("ligand", "receptor"))
nrow(ligand_receptor)
# [1] 50174
lr_q50 <- intercell_consensus_filter(ligand_receptor, 50)
nrow(lr_q50)
# [1] 42863

}
\seealso{
\itemize{
    \item{\code{\link{resources}}}
    \item{\code{\link{intercell}}}
    \item{\code{\link{filter_intercell}}}
    \item{\code{\link{intercell_categories}}}
    \item{\code{\link{intercell_generic_categories}}}
    \item{\code{\link{intercell_resources}}}
    \item{\code{\link{intercell_summary}}}
    \item{\code{\link{intercell_network}}}
}
}
