% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chalmers_gem.R
\name{chalmers_gem_reactions}
\alias{chalmers_gem_reactions}
\title{Reactions from the Chalmers SysBio GEM (Wang et al., 2021)}
\usage{
chalmers_gem_reactions(organism = "Human")
}
\arguments{
\item{organism}{Character or integer: an organism (taxon) identifier.
Supported taxons are 9606 (Homo sapiens), 10090 (Mus musculus),
10116 (Rattus norvegicu), 7955 (Danio rerio), 7227 (Drosophila
melanogaster) and 6239 (Caenorhabditis elegans).}
}
\value{
Data frame of reaction identifiers.
}
\description{
Reactions from the Chalmers SysBio GEM (Wang et al., 2021)
}
\examples{
chalmers_gem_reactions()

}
\references{
Wang H, Robinson JL, Kocabas P, Gustafsson J, Anton M, Cholley
  PE, Huang S, Gobom J, Svensson T, Uhlen M, Zetterberg H, Nielsen J.
  Genome-scale metabolic network reconstruction of model animals as a
  platform for translational research. Proc Natl Acad Sci U S A. 2021 Jul
  27;118(30):e2102344118. doi: \doi{10.1073/pnas.2102344118}.
}
\seealso{
\itemize{
    \item{\code{\link{chalmers_gem_network}}}
    \item{\code{\link{chalmers_gem_metabolites}}}
    \item{\code{\link{chalmers_gem}}}
    \item{\code{\link{chalmers_gem_raw}}}
    \item{\code{\link{chalmers_gem_id_mapping_table}}}
    \item{\code{\link{cosmos_pkn}}}
}
}
