% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omixerCorr.R
\name{omixerCorr}
\alias{omixerCorr}
\title{Correlation Tests}
\usage{
omixerCorr(x, y)
}
\arguments{
\item{x}{Randomization variable (e.g. age)}

\item{y}{Technical covariate (e.g. plate number)}
}
\value{
List of correlation estimate and p-value
}
\description{
This function uses appropriate tests of correlation between
two variables and stores the estimate and p-value in a list.
}
\details{
For two categorical variables, the Cramer's V estimate is
stored alongside chi-square p-value. For all other combinations
of variables, Pearson's correlation coefficient and p-value
are stored.

Please note: variables will be converted to numeric class
within this function.
}
\examples{
library(tibble)
library(forcats)
library(stringr)

sampleList <- tibble(sampleId=str_pad(1:48, 4, pad="0"),
sex=as_factor(sample(c("m", "f"), 48, replace=TRUE)), 
age=round(rnorm(48, mean=30, sd=8), 0), 
smoke=as_factor(sample(c("yes", "ex", "never"), 48, replace=TRUE)),
date=sample(seq(as.Date('2008/01/01'), as.Date('2016/01/01'), 
    by="day"), 48))
                
omixerCorr(sampleList$age, sampleList$sex)
}
