% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_filter.R
\name{tree_filter}
\alias{tree_filter}
\title{Keep rows that include the queried terms and their descendants}
\usage{
tree_filter(.data, col, query, logic = "OR", delim = NULL)
}
\arguments{
\item{.data}{A data frame}

\item{col}{A character (1). Column name to filter by.}

\item{query}{A character vector containing words or ids to be used in the
ontology search}

\item{logic}{A character (1). Operator used to determine filtering method.
Values allowed: "AND", "OR", "NOT". Defaults to "OR"}

\item{delim}{A character (1) used to separate multiple values. If your
`.data` input is obtained from \code{getMetadata} function, this input is
automatically configured.}
}
\value{
Data frame filtered by provided queries along with child terms in the
specified column
}
\description{
Similar to \code{\link[dplyr]{filter}} function, while its filtering 
includes descendants and synonyms of the query term in addition to ontology 
terms and ids identical or similar to the query term across different 
ontologies collected through OLS search.
}
\examples{
meta <- getMetadata("cMD")
tree_filter(meta, disease, c("pancreatic disease", "cancer"))

}
