% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spreadMeta.R
\name{spreadMeta}
\alias{spreadMeta}
\title{Manipulate metadata into a spread format}
\usage{
spreadMeta(meta, targetCol)
}
\arguments{
\item{meta}{A data frame. Harmonized metadata available through the
OmicsMLRepoR package. It should have the `package` column.}

\item{targetCol}{A character. The column name(s) to expand if present. 
If multiple columns are specified here, they should be separated by 
the `sep` and the column name and its value should be separated by the 
provided `delim`.}
}
\value{
A metadata table where the `targetCol` is updated to a long form (if it
is multi-valued attribute) or spread into multiple columns (if it is 
composite attribute).
}
\description{
This function speads gout multiple values per attribute (‘multi-valued’ 
attribute) or multiple features under a single generic attribute 
(‘composite’ attribute). Multi-valued attribute will return 'long' table, 
while composite attribute will return 'wide' table.
}
\examples{
data(mini_cmd2) # multi-valued attribute
data(mini_cmd3) # composite attribute
spreadMeta(mini_cmd2, "target_condition")
spreadMeta(mini_cmd3, "probing_pocket_depth")

data(mini_cbio)
trt_cols <- grep("^treatment_", colnames(mini_cbio), value = TRUE)
spreadMeta(mini_cbio, targetCol = trt_cols)

}
