% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontoSummarize.R
\name{ontoSummarize}
\alias{ontoSummarize}
\title{Groups ontology terms by the child term of a provided "parent" they fall
under}
\usage{
ontoSummarize(parent, descendants, ontology)
}
\arguments{
\item{parent}{Character; Term to use as parent of summarized children}

\item{descendants}{Character vector; Terms to summarize as children of parent}

\item{ontology}{Character; Ontology database ID}
}
\value{
A dataframe containing the descendants summarized into groups. Name
of each group is the child of the parent that the descendants are grouped
under. Both IDs and labels of the ontology terms are provided.
}
\description{
Groups ontology terms by the child term of a provided "parent" they fall
under
}
\examples{
ontology <- "ncit"
parent <- "NCIT:C17049"
descendants <- c("NCIT:C44265", "NCIT:C77811", "NCIT:C43856",
                 "NCIT:C43672", "NCIT:C2991", "NCIT:C43860")
ontoSummarize(parent, descendants, ontology)

}
