% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge_vectors}
\alias{merge_vectors}
\title{Custom function to merge vectors}
\usage{
merge_vectors(base, update, sep = ":", delim = ";")
}
\arguments{
\item{base}{A character. A space-holder version of the key:value 
concatenates (e.g., `column1:NA;column2:NA;column3:NA`)}

\item{update}{A character. The target string to be compared and filled with 
`base` if there is missing pairs. (e.g., `column1:value1;column3:value3`)}

\item{sep}{A character string to separate the column name and value. 
Default is `:`}

\item{delim}{A character string to separate the column:value pairs. 
Default is `;`}
}
\value{
A character updated the target string (`update`) to follow the
reference string (`base`).
}
\description{
This function is designed for a group of, collapsible metadata attributes
(e.g., 'biomarker' for curatedMetagenomicData).
}
\examples{
x <- "color:NA;shape:NA;size:NA"
y <- "color:green;size:large"
merge_vectors(x, y)

}
