% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spreadMeta.R
\name{getWideMetaTb}
\alias{getWideMetaTb}
\title{Create individual columns for different attributes stored in one column}
\usage{
getWideMetaTb(meta, targetCol = NULL, sep = ":", delim = "<;>", remove = TRUE)
}
\arguments{
\item{meta}{A data frame.}

\item{targetCol}{A character. The column name(s) to expand if present. 
If multiple columns are specified here, they should be separated by 
the `sep` and the column name and its value should be separated by the 
provided `delim`.}

\item{sep}{A character (1). Delimiter used to concatenate column name 
and its value. Default is double colons, `:`.}

\item{delim}{A character(1). Separator used between values. Default `<;>`.}

\item{remove}{If `TRUE`, remove input columns from output data frame.}
}
\value{
A data frame where the contents under `targetCol` is split into
individual columns in an alphabetical order. Data type of the expanded 
columns is all character.
}
\description{
The values stored in one column should include their potential column
names to use this function.
}
\examples{
## Narrow-table example
narrow_tb <- data.frame(fruit = c("apple", "banana", "pear", "watermelon", 
                                  "grape"), 
                        feature = c("color:red;shape:round;size:medium", 
                                    "color:yellow;shape:long;size:medium",
                                    "color:brown;shape:NA;size:NA",
                                    "color:green;shape:round;size:large",
                                    "color:purple;shape:NA;size:small"))
getWideMetaTb(narrow_tb, targetCol = "feature", sep = ":", delim = ";")

## Narrow-table example with missing columns
narrow_tb2 <- data.frame(fruit = c("apple", "banana", "pear", 
                                   "watermelon", "grape"), 
                        feature = c("color:red;shape:round;size:medium", 
                                    "color:yellow;shape:long;size:medium",
                                    NA,
                                    "color:green;size:large",
                                    "color:purple;shape:NA;size:small"))
getWideMetaTb(narrow_tb2, targetCol = "feature", sep = ":", delim = ";")

## Subset of cMD metadata
data(mini_cmd3)
wtb <- getWideMetaTb(mini_cmd3, targetCol = "probing_pocket_depth")
head(wtb)

}
