% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatherMeta.R
\name{getShortMetaTb}
\alias{getShortMetaTb}
\title{Compresses expanded metadata columns to one row per sample}
\usage{
getShortMetaTb(meta, idCols = NULL, targetCol = NULL, delim = "<;>")
}
\arguments{
\item{meta}{A data frame with expanded treatment columns.}

\item{idCols}{Optional. A character vector of columns that identify 
single samples, such as 'curation_id' and 'sampleId'. Defaults to 
standard ID columns.}

\item{targetCol}{Optional. A character vector of columns to compress if 
present. Default is names of all cBioPortal treatment-related columns.}

\item{delim}{Optional. A delimiter string. Default is `<;>`.}
}
\value{
A data frame where each sample gets a single row
}
\description{
Compresses expanded metadata columns to one row per sample
}
\examples{
data(mini_cmd)
lmeta <- getLongMetaTb(mini_cmd, "hla")
res <- getShortMetaTb(lmeta, targetCol = "hla")
dim(res) # 200 x 3 table

long_tb <- data.frame(ind = c("A", "A", "B", "C", "D", "D", "E"),
                      aval = c("cat", "dog", "chicken", "horse", 
                               "frog", "pig", "snake"),
                      cval = c(1, 1, NA, 3, 4, 4, 5),
                      bval = c("red", "blue", "yellow", NA, "green", 
                               NA, "brown"))
getShortMetaTb(long_tb, idCols = "ind", targetCol = c("aval", "bval"))

}
