% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOntoInfo.R
\name{getOntoInfo}
\alias{getOntoInfo}
\title{Query Ontology Lookup Service (OLS)}
\usage{
getOntoInfo(query, ontology = "", exact = FALSE, rows = 20)
}
\arguments{
\item{query}{A character (1) containing the search query, either a term
label or term id.}

\item{ontology}{A character vector defining the ontology to be queried. 
Default is the empty character, to search all ontologies.}

\item{exact}{A logical (1) defining if OLS search is restricted to exact
matches. Defaults is `FALSE`.}

\item{rows}{An integer (1) defining the number of query returns. 
Default is 20L. Maximum number of values returned by the server is 1000.}
}
\value{
A tibble containing ontology term label and description
}
\description{
Extract identical or similar ontology terms across different ontologies
}
\examples{
getOntoInfo("NCIT:C4872")
getOntoInfo("NCIT:C4872", ontology = c("EFO", "MONDO"))
getOntoInfo("Skin Infection")
getOntoInfo("Sitagliptin", ontology = c("Chebi", "apple"))

## Multiple query values
getOntoInfo("plasma,membrane")
getOntoInfo(c("plasma", "membrane"))

}
