% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatherMeta.R
\name{getNarrowMetaTb}
\alias{getNarrowMetaTb}
\title{Collapse values from multiple columns into one}
\usage{
getNarrowMetaTb(
  meta,
  newCol = NULL,
  targetCol = NULL,
  sep = ":",
  delim = ";",
  remove = TRUE,
  na.rm = TRUE,
  sort = TRUE
)
}
\arguments{
\item{meta}{A data frame.}

\item{newCol}{A character (1). Name of the new column to store collapsed
values.}

\item{targetCol}{A character vector. Names of the columns to be collapsed
into one column.}

\item{sep}{A character (1). Delimiter used to concatenate column name 
and its value. Default is double colons, `:`.}

\item{delim}{A character(1). Separator to use between values/columns. 
Default is `;`.}

\item{remove}{With the default, `TRUE`, this function will remove input 
columns from output data frame.}

\item{na.rm}{With the default, `TRUE`, missing values will be removed 
prior to uniting each value.}

\item{sort}{With the default, `TRUE`, the united columns will be ordered
alphabetically.}
}
\value{
A data frame where target columns (\code{targetCol}) are collapsed
into a single column. The original column name and its value are 
concatenated with the `sep` input and the column:value pairs are separated
by the `delim` input. Target columns will be merged in the alphabetical 
order of their names.
}
\description{
Collapse values from multiple columns into one
}
\examples{
wide_tb <- data.frame(fruit = c("apple", "banana", "pear", "watermelon", 
                                "grape"), 
                      shape = c("round", "long", NA, "round", NA),
                      color = c("red", "yellow", NA, "green", "purple"),
                      size = c("medium", "medium", NA, "large", "small"))
getNarrowMetaTb(wide_tb, 
                newCol = "feature", 
                targetCol = c("color", "shape", "size"), 
                sep = ":", delim = ";")

}
