% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spreadMeta.R
\name{getLongMetaTb}
\alias{getLongMetaTb}
\title{Expands metadata with multiple values belong to a same attribute}
\usage{
getLongMetaTb(meta, targetCol = NULL, delim = NULL)
}
\arguments{
\item{meta}{A data frame. Each column (and associated `ontology_term_id`
column) should use the same delimiter to separate multiple, same-numbered
values.}

\item{targetCol}{A character. The column name(s) to expand if present. 
If multiple columns are specified here, they should be separated by 
the `sep` and the column name and its value should be separated by the 
provided `delim`.}

\item{delim}{Optional. A character (1) of a delimiter used to separate 
multiple values in the metadata table.}
}
\value{
A data frame of metadata expanded so that each individual treatment 
has its own row.
}
\description{
Same as the `getWideMetaTb` function, this function accepts single
target column (`targetCol`). The target columns (and linked, accessory
columns) should have the same number of elements separated by the `delim`, 
and the multiple values for each column belongs to the same column/
attribute/field, i.e., no additional column name is required/provided.
}
\examples{
data(mini_cmd)
lmeta <- getLongMetaTb(mini_cmd, "hla")
dim(mini_cmd) 
dim(lmeta) 

data(mini_cmd2)
lmeta2 <- getLongMetaTb(mini_cmd2, "target_condition")
head(lmeta2, 3)

data(mini_cbio)
trt_cols <- grep("^treatment_", colnames(mini_cbio), value = TRUE)
lmeta3 <- getLongMetaTb(mini_cbio, targetCol = trt_cols)

short_tb <- data.frame(
    ind = c("A", "B", "C", "D", "E"),
    aval = c("cat;dog", "chicken", "horse", "frog;pig", "snake"),
    cval = c(1, NA, 3, 4, 5),
    bval = c("red;blue", "yellow", "NA", "green;NA", "brown"))
    
getLongMetaTb(short_tb, c("aval", "bval"), delim = ";")

}
