% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProbNull.R
\name{postProbNull}
\alias{postProbNull}
\title{Posterior probabilities of each component null hypothesis}
\usage{
postProbNull(y, group, weights = NULL, alpha = "moderated",
  detail.return = TRUE)
}
\arguments{
\item{y}{a numeric matrix containing log-expression or logCPM
(log2-counts per million) values.
Data frame or SummarizedExperiment object will be
internally coerced into a matrix.
Rows correspond to probes and columns to samples.
Missing values are not permitted.}

\item{group}{categorical vector or factor giving group membership of
columns of y. At least two categories need to be presented.}

\item{weights}{optional numeric matrix containing prior weights
for each spot.}

\item{alpha}{parameter specifying within-group variance estimator to be used.
'moderated': empirical Bayes moderated variance estimator as used in
\code{\link[limma]{eBayes}}.
Numeric value: a constant value added to pooled variance estimator
(\eqn{\alpha + \sigma}).
NULL: no estimator; all variances are set to be 1.}

\item{detail.return}{a logical indicating whether more details (e.g. lfdr)
will be returned.}
}
\value{
a list containing the following components:
\item{W}{a matrix of posterior probabilities for each component null
hypothesis given an observed probe. Rows correspond to probes and columns
to one hypothesis.}
\item{label}{a vector of group labels.}
\item{groupOrder}{a matrix with each row being group indexes ordered based
on decreasing expression levels.
Group indexes are positions in \code{label}.}
\item{F.p.value}{a matrix with each column giving p-values corresponding
to F-statistics on certain groups.}
\item{lfdr}{a matrix with each column being local false discovery rates
estimated based on one column of weighted F.p.value matrix.}
\item{fit}{a \code{MArrayLM} fitted model object produced by \code{lmFit}.}
\code{F.p.value}, \code{lfdr} and \code{fit} are returned only when
\code{detail.return} is TRUE.
}
\description{
This function computes posterior probabilities of each component null
hypothesis given observed probes. Such probe-wise probabilities
will be used as weights for aggregating permutations.
}
\details{
Posterior probabilities of each component null hypothesis given
observed probes are estimated from ANOVA test on certain groups and local
fdr. There are totally (\eqn{K-1}) null hypotheses, where \eqn{K} is the
number of groups.
}
\examples{
data(RocheBT)
ppnull <- postProbNull(RocheBT$y, RocheBT$group, alpha='moderated')
ppnull <- postProbNull(RocheBT$y, RocheBT$group, alpha=0.1)
}
