% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizeFactor.R
\docType{methods}
\name{sizeFactors}
\alias{sizeFactors}
\alias{sizeFactors,OutriderDataSet-method}
\alias{sizeFactors<-}
\alias{sizeFactors<-,OutriderDataSet,numeric-method}
\alias{estimateSizeFactors}
\alias{estimateSizeFactors,OutriderDataSet-method}
\alias{sizeFactors<-,OutriderDataSet,NULL-method}
\title{SizeFactors accessor and estimation function}
\usage{
\S4method{sizeFactors}{OutriderDataSet}(object)

\S4method{sizeFactors}{OutriderDataSet,numeric}(object) <- value

\S4method{sizeFactors}{OutriderDataSet,NULL}(object) <- value

\S4method{estimateSizeFactors}{OutriderDataSet}(object)
}
\arguments{
\item{object}{OutriderDataSet}

\item{value}{A numberic vector of sizeFactors}
}
\value{
An OutriderDatasSet with the estimated sizeFactors, or with the 
            getter function it returns a numeric vector containing the 
            sizeFactors.
}
\description{
Accessor functions for the 'sizeFactors' information in a OutriderDataSet
object.
}
\details{
The estimation of the size factors can also make use of the existing 
log geometric means in the object. Those can be loaded from an 
existing model.
}
\examples{

ods <- makeExampleOutriderDataSet()
ods <- estimateSizeFactors(ods)
head(sizeFactors(ods))

sizeFactors(ods) <- runif(dim(ods)[2], 0.5, 1.5)
sizeFactors(ods)
counts(ods, normalized=TRUE)[1:10,1:10]
        
}
\seealso{
\code{\link[DESeq2]{estimateSizeFactors}}
}
