% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/filterExpression.R
\name{filterExpression}
\alias{filterExpression}
\alias{filterExpression,OutriderDataSet-method}
\title{Filter expression}
\usage{
filterExpression(object, ...)

\S4method{filterExpression}{OutriderDataSet}(
  object,
  gtfFile,
  fpkmCutoff = 1,
  percentile = 0.95,
  filterGenes = TRUE,
  savefpkm = FALSE,
  minCounts = FALSE,
  addExpressedGenes = TRUE,
  ...
)
}
\arguments{
\item{object}{An OutriderDataSet object}

\item{...}{Additional arguments passed to \code{computeGeneLength}}

\item{gtfFile}{A txDb object or a GTF/GFF file to be used as annotation}

\item{fpkmCutoff}{The threshold for filtering based on the FPKM value}

\item{percentile}{a numeric indicating the percentile FPKM value to compare
against the \code{fpkmCutoff}}

\item{filterGenes}{If TRUE, the default, the object is subseted.}

\item{savefpkm}{If TRUE, the FPKM values are saved as assay}

\item{minCounts}{If TRUE, only genes with 0 counts in all samples are 
filtered}

\item{addExpressedGenes}{If TRUE (default), adds 5 columns to the
\code{colData} with information regarding the number of 
expressed genes per sample}
}
\value{
An OutriderDataSet containing the \code{passedFilter} column, which
            indicates if the given gene passed the filtering threshold. If
            \code{filterGenes} is TRUE the object is already subsetted.
}
\description{
To filter out non expressed genes this method uses the FPKM values to 
get a comparable value over genes. For each gene, if the pth-
\code{percentile} is greater than the \code{fpkmCutoff} value, it passes the
filter. To calcute the FPKM values the user needs to provide a GTF file or 
the basepair parameter as described in \code{\link[DESeq2]{fpkm}}.
}
\examples{
ods <- makeExampleOutriderDataSet(dataset="GTExSkinSmall")
annotationFile <- system.file("extdata", 
    "gencode.v19.genes.small.gtf.gz", package="OUTRIDER")
ods <- filterExpression(ods, annotationFile, filterGenes=FALSE)

mcols(ods)['passedFilter']
fpkm(ods)[1:10,1:10]
dim(ods)

ods <- ods[mcols(ods)[['passedFilter']]]
dim(ods)

}
