% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-counts.R
\docType{methods}
\name{counts}
\alias{counts}
\alias{counts,OutriderDataSet-method}
\alias{counts<-,OutriderDataSet,matrix-method}
\title{Accessors for the 'counts' slot of an OutriderDataSet object.}
\usage{
\S4method{counts}{OutriderDataSet}(object, normalized = FALSE, minE = 0.5, ...)

\S4method{counts}{OutriderDataSet,matrix}(object, ...) <- value
}
\arguments{
\item{object}{An \code{\link{OutriderDataSet}} object}

\item{normalized}{TRUE/FALSE whether counts should be normalized}

\item{minE}{The minimal expected count, defaults to 0.5, to be used in 
computing the expected log geom mean.}

\item{...}{Further arguments are passed on to the underlying assay function}

\item{value}{An integer matrix containing the counts}
}
\value{
A matrix containing the counts
}
\description{
The counts slot holds the count data as a matrix of non-negative integer
count values, one row for each observational unit (eg.: gene), and one
column for each sample.
}
\details{
By default this function returns the raw counts. If conrol factors are
computed or provided the normalized counts can be returned using 
normalized = TRUE. The offset parameter can be used to add a pseudocount
to the count before dividing by the normalization. This can be usefull 
when the log(counts) are computed and in case the controll values are in 
the same oder of magnited as the counts.
}
\examples{

ods <- makeExampleOutriderDataSet()
counts(ods)[1:10,1:10]

ods <- estimateSizeFactors(ods)
counts(ods, normalized=TRUE)[1:10,1:10]

}
\seealso{
\code{\link{sizeFactors}}, \code{\link{normalizationFactors}}
}
