% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORFs_helpers.R
\name{uniqueGroups}
\alias{uniqueGroups}
\title{Get the unique set of groups in a GRangesList}
\usage{
uniqueGroups(grl)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}}}
}
\value{
a GRangesList of unique orfs
}
\description{
Sometimes \code{\link{GRangesList}} groups might be identical,
for example ORFs from different isoforms can have identical ranges.
Use this function to reduce these groups to unique elements
in \code{\link{GRangesList}} \code{grl}, without names and metacolumns.
}
\examples{
gr1 <- GRanges("1", IRanges(1,10), "+")
gr2 <- GRanges("1", IRanges(20, 30), "+")
# make a grl with duplicated ORFs (gr1 twice)
grl <- GRangesList(tx1_1 = gr1, tx2_1 = gr2, tx3_1 = gr1)
uniqueGroups(grl)

}
\seealso{
Other ORFHelpers: 
\code{\link{defineTrailer}()},
\code{\link{longestORFs}()},
\code{\link{mapToGRanges}()},
\code{\link{orfID}()},
\code{\link{startCodons}()},
\code{\link{startSites}()},
\code{\link{stopCodons}()},
\code{\link{stopSites}()},
\code{\link{txNames}()},
\code{\link{uniqueOrder}()}
}
\concept{ORFHelpers}
