% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imports.R
\name{readWig}
\alias{readWig}
\title{Custom wig reader}
\usage{
readWig(path, chrStyle = NULL)
}
\arguments{
\item{path}{a character path to two .wig files, or a data.table
with 2 columns, (forward, filepath) and reverse, only 1 row.}

\item{chrStyle}{a GRanges object, TxDb, FaFile,
, a \code{\link{seqlevelsStyle}} or \code{\link{Seqinfo}}.
(Default: NULL) to get seqlevelsStyle from. In addition if it
is a Seqinfo object, seqinfo will be updated.
Example of seqlevelsStyle update:
Is chromosome 1 called chr1 or 1,
 is mitocondrial chromosome called MT or chrM etc.
Will use 1st seqlevel-style if more are present.
Like: c("NCBI", "UCSC") -> pick "NCBI"}
}
\value{
a \code{\link{GRanges}} object of the file/s
}
\description{
Given 2 wig files, first is forward second is reverse.
Merge them and return as GRanges object.
If they contain name reverse and forward, first and second order
does not matter, it will search for forward and reverse.
}
\seealso{
Other utils: 
\code{\link{bedToGR}()},
\code{\link{convertToOneBasedRanges}()},
\code{\link{export.bed12}()},
\code{\link{export.bigWig}()},
\code{\link{export.fstwig}()},
\code{\link{export.wiggle}()},
\code{\link{fimport}()},
\code{\link{findFa}()},
\code{\link{fread.bed}()},
\code{\link{optimizeReads}()},
\code{\link{readBam}()},
\code{\link{readBigWig}()}
}
\concept{utils}
