% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_helpers.R
\name{groupGRangesBy}
\alias{groupGRangesBy}
\title{Group GRanges}
\usage{
groupGRangesBy(gr, other = NULL)
}
\arguments{
\item{gr}{a GRanges object}

\item{other}{a vector of unique names to group by (default: NULL)}
}
\value{
a GRangesList named after names(GRanges) if other is NULL, else
names are from unique(other)
}
\description{
It will group / split the GRanges object by the argument `other`.
For example if you would like to to group GRanges object by gene,
set other to gene names. \cr
If `other` is not specified function will try to use the names of the
GRanges object. It will then be similar to `split(gr, names(gr))`.
}
\details{
It is important that all intended groups in `other` are uniquely named,
otherwise duplicated group names will be grouped together.
}
\examples{
ORFranges <- GRanges(seqnames = Rle(rep("1", 3)),
                     ranges = IRanges(start = c(1, 10, 20),
                                      end = c(5, 15, 25)),
                     strand = "+")
ORFranges2 <- GRanges("1",
                      ranges = IRanges(start = c(20, 30, 40),
                                       end = c(25, 35, 45)),
                      strand = "+")
names(ORFranges) = rep("tx1_1", 3)
names(ORFranges2) = rep("tx1_2", 3)
grl <- GRangesList(tx1_1 = ORFranges, tx1_2 = ORFranges2)
gr <- unlist(grl, use.names = FALSE)
## now recreate the grl
## group by orf
grltest <- groupGRangesBy(gr) # using the names to group
identical(grl, grltest) ## they are identical

## group by transcript
names(gr) <- txNames(gr)
grltest <- groupGRangesBy(gr)
identical(grl, grltest) ## they are not identical

}
