% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_expression_helpers.R
\name{DEG_model_results}
\alias{DEG_model_results}
\title{Get DESeq2 model results from DESeqDataSet}
\usage{
DEG_model_results(
  ddsMat_rna,
  target.contrast,
  pairs,
  p.value = 0.05,
  lfcShrinkType = "normal",
  as.data.table = TRUE
)
}
\arguments{
\item{ddsMat_rna}{a DESeqDataSet object with results stored as metadata columns.}

\item{target.contrast}{a character vector, default \code{design[1]}.
The column in the ORFik experiment that represent the comparison contrasts.
By default: the first design factor of the full experimental design.
This is the factor you will do the comparison on. DESeq will normalize
the counts based on the full design, but the log fold change values will
be based on this contrast only. It is usually the 'condition' column.}

\item{pairs}{list of character pairs, the experiment contrasts. Default:
\code{combn.pairs(unlist(df.rfp[, target.contrast])}}

\item{p.value}{a numeric, default 0.05 in interval (0,1). Defines adjusted
p-value to be used as significance threshold for the result groups. I.e.
for exclusive translation group significant subset for p.value = 0.05 means:
TE$padj < 0.05 & Ribo$padj < 0.05 & RNA$padj > 0.05.}

\item{lfcShrinkType}{character or NULL. Default "normal", which
shrinkage to apply to results for low count gene subset.
This avoids the problem of extreme fold changes,
 when counts are low. See \link[DESeq2]{lfcShrink}.
A note for DTEG.analysis function: The interaction term (TE),
is not shrunked as this is not counts, but a ratio.}

\item{as.data.table}{logical, default TRUE. Return as data.table or list of DESeq result objects (FALSE).}
}
\value{
a data.table or list
}
\description{
Get DESeq2 model results from DESeqDataSet
}
\examples{
## Simple example (use ORFik template, then use only RNA-seq)
df <- ORFik.template.experiment()
df.rna <- df[df$libtype == "RNA",]
design(df.rna) # The full experimental design
target.contrast <- design(df.rna)[1] # Default target contrast
#ddsMat_rna <- DEG_model(df.rna, target.contrast)
#pairs <- combn.pairs(unlist(df[, target.contrast]))
#dt <- DEG_model_results(ddsMat_rna, target.contrast, pairs)
}
