% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translateORFs.r
\name{translateORFs}
\alias{translateORFs}
\title{Translate open reading frames to proteins}
\usage{
translateORFs(seqORFs, aaSymbol = 1, workDir = NULL)
}
\arguments{
\item{seqORFs}{character string giving the name of FASTA/FA file with
sequences of identified open reading frames.}

\item{aaSymbol}{type of amino acid symbols (one- or three-letter coding).
Default value is 1.}

\item{workDir}{character string giving the path to and name of work
directory. NULL by default that mean the current working directory.}
}
\value{
AAStringSet object with protein sequences.
}
\description{
Translate the identified open reading frames to proteins.
}
\examples{
seq_orf_path <- system.file("extdata",
                            "Set.trans_ORFs.sequences.fasta",
                            package = "ORFhunteR")
prot_seqs <- translateORFs(seqORFs = seq_orf_path)
}
\author{
Vasily V. Grinev
}
