% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifyORFsCandidates.R
\name{classifyORFsCandidates}
\alias{classifyORFsCandidates}
\title{Classify the pseudo and true ORF candidates derived from RNA molecules}
\usage{
classifyORFsCandidates(
  ORFLncRNAs,
  ORFmRNAs,
  pLearn = 0.75,
  nTrees = 500,
  modelRF = NULL,
  workDir = NULL,
  showAccuracy = FALSE
)
}
\arguments{
\item{ORFLncRNAs}{the oject of the class list of non-coding pseudo ORFs.}

\item{ORFmRNAs}{the oject of the class list of coding true ORFs.}

\item{pLearn}{probability threshold for the "traing" class of ORFs.
Default value is 0.75.}

\item{nTrees}{nuber of the decision trees in randomForest.
Default value is 500.}

\item{modelRF}{character string giving the name of RDS-file to store
the classification model. NULL by default.}

\item{workDir}{character string giving the path to and name of work
directory. NULL by default that mean the current working directory.}

\item{showAccuracy}{logic TRUE or FALSE. Use TRUE for print accuracy metrics. 
Default value is FALSE}
}
\value{
The classificator object of the class randomForest.
}
\description{
Clussify the pseudo and true ORF candidates.
}
\examples{
\dontrun{
clt <- classifyORFsCandidates(ORFLncRNAs, ORFmRNAs)
}
}
\author{
Mikalai M. Yatskou
}
