\name{descriptor}
\alias{descriptor}

\title{
Distribution of Assays as percentage of cell lines
}
\description{

descriptor() produces panels of boxplots displaying the
distribution of various factors(e.g. ChIP-seq of H3k9ac
histone modification) in percentage of cell lines.

choice = 1 output is collection of boxplots explaining the
distribution of percentage of cell lines having or overlapping
with the input factors (e.g. H3k9ac).

choice = 2 displays the distribution of percentage of cell
lines having or overlapping with increasing number of factors
for the selected group (e.g. WE or RE etc).
If this option is selected, then a group name should be
provided through choice2group.
}
\usage{

descriptor(name, factors, groups,
choice = 1, choice2group = NULL, title = NULL,
groupinfo = NULL)
}

\arguments{
\item{name}{
Name of the "MultiAssayExperiment" object containing the assay data
}
\item{factors}{
A vector containing the name of the Assays
}
\item{groups}{
Name of all or subset of groups
}

\item{choice}{
Numerical value between 1 and 2. See Description and vignettes for
details of plots generated by this 2 choices
}

\item{choice2group}{
Used when choice is 2. This argument allows a name of group.
}
\item{title}{
Title of the plot
}
\item{groupinfo}{
output of create_group() or similar object
}
}
\value{
Displays various plots as per the combination of various input arguments.
}
\author{
Subhadeep Das <subhadeep1024@gmail.com>
}

\examples{

descriptor(name = multi_assay,
factors = c(
"H2az","H3k9ac","H3k4me1"),
groups = c("WE","RE","IntE","NE"),
choice = 1,
title = "Distribution of percentage of cell types overlapping
with various factors",
groupinfo = groupinfo_ext)

}
