\name{p.spatial2}
\alias{p.spatial2} 
\title{Assessment of the significance of spatial bias based on p-values}
\description{This function assesses the significance of spatial bias.  This is 
achieved by comparing the observed average values of logged fold-changes within a spot's spatial neighbourhood
with an empirical distribution generated by permutation tests. The significance is given
by (adjusted) p-values derived in one-sided permutation test.}
\usage{p.spatial2(object,delta=2,N=-1,av="median",p.adjust.method="none")}
\arguments{\item{object}{object of class marrayRaw or marrayNorm}
              \item{delta}{integer determining the size of spot neighbourhoods 
            (\code{(2*delta+1)x(2*delta+1)}).}
           \item{N}{number of samples for  generation of empirical background distribution}
            \item{av}{averaging of \code{M} within neighbourhood by \emph{mean} or \emph{median} (default)}      
           \item{p.adjust.method}{method for adjusting p-values due to multiple testing regime. The available
                 methods are \dQuote{none}, \dQuote{bonferroni},  \dQuote{holm}, \dQuote{hochberg},
                 \dQuote{hommel} and \dQuote{fdr}.  See also \code{\link{p.adjust}}.} }
\details{ The function \code{p.spatial2.Rd} is basically the same as  \code{p.spatial},
          but differs in its input and output formats. Details about the functionality  can be found
          at  \code{\link{p.spatial}}.
  }

\value{A list of a two lists of vectors is produced containing the p-values  for positive (\code{Pp}) 
        and negative (\code{Pn}) deviations of
       \eqn{\bar{M}}{median/mean of \code{M}} of the spot's neighbourhood is produced (see example below).  }
\note{This function will be fused with \code{p.spatial} in future versions using S4-style methods.} 
\author{Matthias E. Futschik (\url{http://itb.biologie.hu-berlin.de/~futschik})}
\seealso{ \code{\link{fdr.int}}, \code{\link{sigxy.plot}}, \code{\link{p.adjust}},\code{\link{p.spatial}}}

\examples{

# To run these examples, "un-comment" them!
#
# LOADING DATA
# data(sw)
# 
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
# For this illustration, N was chosen rather small. For "real" analysis, it should be larger.
# P <- p.spatial2(sw,delta=2,N=10000,av="median")
# SIGNIFICANCE PLOTS OF ARRAY 1
# sigxy.plot2(sw[,1],P$Pp[[1]],P$Pn[[1]],color.lim=c(-5,5),main="P-value")
# SIGNIFICANCE PLOTS OF ARRAY 3
# sigxy.plot2(sw[,3],P$Pp[[3]],P$Pn[[3]],color.lim=c(-5,5),main="P-value")


}



\keyword{nonparametric}
\keyword{univar}
\keyword{htest}



