% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{covPlot}
\alias{covPlot}
\title{Coverage plot}
\usage{
covPlot(
  OGREDataSet,
  datasets = names(OGREDataSet)[seq(2, length(OGREDataSet))],
  nbin = 100
)
}
\arguments{
\item{OGREDataSet}{An OGREDataSet}

\item{datasets}{\code{character vector} of subject dataset names. Default:
Generates a coverage plots for all subjects}

\item{nbin}{Number of bins}
}
\value{
OGREDataSet.
}
\description{
Generates coverage plots of all subject datasets and stores them as a list,
that can be accessed by \code{metadata(OGREDataSet)$covPlot}
}
\examples{
myOGRE <- makeExampleOGREDataSet()
myOGRE <- loadAnnotations(myOGRE)
myOGRE <- fOverlaps(myOGRE)
myOGRE <- covPlot(myOGRE)
metadata(myOGRE)$covPlot
}
