% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{addGRanges}
\alias{addGRanges}
\title{Add GenomicRanges}
\usage{
addGRanges(OGREDataSet, dataSet, type, label = NULL)
}
\arguments{
\item{OGREDataSet}{An OGREDataSet}

\item{dataSet}{A GRanges object. Each region needs chromosome, start, end and
strand information. A unique ID and a name column must be present in the
\code{GenomicRanges} object metadata. Avoid different chromosome naming
conventions i.e. (chr1, CHR1, 1, I) among all datasets}

\item{type}{Type of dataSet, must be either query or subject. If query the
dataSet will be added as query and at the first position of OGREDataSet.}

\item{label}{A \code{character} that will label your GRanges object. If
not supplied, the label will be guessed from the dataset parameter.}
}
\value{
OGREDataSet.
}
\description{
Add a GenomicRanges dataset to OGREDataSet
}
\examples{
myOGRE <- OGREDataSet()
myGRanges <- makeExampleGRanges()
myOGRE <- addGRanges(myOGRE,myGRanges,"query")
}
