% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateStatistics.R
\name{reduceTechnicalReplicates}
\alias{reduceTechnicalReplicates}
\title{Remove technical replicates from data and design}
\usage{
reduceTechnicalReplicates(se, techRepColName, sampleColName)
}
\arguments{
\item{se}{Summarized experiment where the assay contains the data to be
reduced, and the colData the data frame}

\item{techRepColName}{Technical replicates column name in colData}

\item{sampleColName}{Sample names column name in colData}
}
\value{
reducedSe Summarized experiment with reduced data
}
\description{
Collapses sample values into their average. If only one value is present
due to NA-values in other technical replicates, then that value is used.
}
\details{
Takes a SummarizedExperiment where the data is present as the assay
and the colData contains the design conditions. In the design conditions
there should be one column with the technical replicate groups and one
column containing the sample names
}
\examples{
testData <- as.matrix(data.frame(
    c(1,1,1), 
    c(1,2,1), 
    c(7,7,7), 
    c(7,9,7)))
colnames(testData) <- c("a1", "a2", "b1", "b2")
designDf <- data.frame(
    sample=c("a1", "a2", "b1", "b2"), 
    techrep=c("a", "a", "b", "b"))
se <- SummarizedExperiment::SummarizedExperiment(
    assay=testData,
    colData=designDf
)
statObj <- reduceTechnicalReplicates(se, "techrep", "sample")
}
