% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalyzerResults.R
\name{NormalyzerResults}
\alias{NormalyzerResults}
\title{Representation of the results from performing normalization over a dataset}
\usage{
NormalyzerResults(nds)

NormalyzerResults(nds)
}
\arguments{
\item{nds}{NormalyzerDataset object}
}
\value{
nr Prepared NormalyzerResults object
}
\description{
It is linked to a NormalyzerDataset instance representing the raw data
which has been processed. After performing evaluation it also links to
an instance of NormalyzerEvaluationResults representing the results
from the evaluation.
}
\section{Slots}{

\describe{
\item{\code{normalizations}}{SummarizedExperiment object containing calculated
normalization results}

\item{\code{nds}}{Normalyzer dataset representing run data}

\item{\code{ner}}{Normalyzer evaluation results
for running extended normalizations}
}}

\examples{
data(example_summarized_experiment)
normObj <- getVerifiedNormalyzerObject("job_name", example_summarized_experiment)
emptyNormResults <- NormalyzerResults(normObj)
}
