% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{writeEnrichment}
\alias{writeEnrichment}
\title{Write the tabular form of the pathway or GO term enrichment results}
\usage{
writeEnrichment(mrnaObject, fileName, sept = "\\t", type = "pAdjust", n)
}
\arguments{
\item{mrnaObject}{Object of the enrichment result}

\item{fileName}{File name of the txt file}

\item{sept}{File separator, by default, it is tab('\\t')}

\item{type}{Draw the dot plot according to the p-value or adjusted
p-value ("pvalue", "pAdjust"). Default value is "pAdjust".}

\item{n}{Number of GO terms or pathways, that ordered by type and has least
number of top p-value}
}
\value{
Text file of the enrichment results in a tabular format
}
\description{
Write the tabular form of the pathway or GO term enrichment results
}
\examples{
\dontrun{
ncGO<-geneGOEnricher(gene = brain_disorder_ncRNA, org_assembly='hg19',
   near=TRUE, genetype = 'Ensembl_gene')
   
writeEnrichment(mrnaObject = ncGO,fileName = "a.txt",sept = '\t')
}

}
