% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{annGO}
\alias{annGO}
\title{Annotate the set of genes with the GO terms for a given species and
assembly}
\usage{
annGO(
  genes,
  GOtype = c("BP", "CC", "MF"),
  org_assembly = c("hg19", "hg38", "mm10", "dre10", "rn6", "dm6", "ce11", "sc3")
)
}
\arguments{
\item{genes}{List of mRNA genes. Supported format for genes is Hugo.}

\item{GOtype}{Hierarchical category of the GO ontology. Possible
values are 'BP', 'CC', 'MF'.}

\item{org_assembly}{Genome assembly of interest. Possible assemblies are
'mm10' for mouse, 'dre10' for zebrafish, 'rn6' for rat, 'dm6' for fruit
fly, 'ce11' for worm, 'hg19' and 'hg38' for human}
}
\value{
data frame of the GO term annotation of the genes
}
\description{
Annotate the set of genes with the GO terms for a given species and
assembly
}
