% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/newFit.R
\name{newFit}
\alias{newFit}
\alias{newFit,SummarizedExperiment-method}
\alias{newFit,matrix-method}
\alias{newFit,DelayedMatrix-method}
\alias{newFit,dgCMatrix-method}
\title{Fit a nb regression model}
\usage{
newFit(Y, ...)

\S4method{newFit}{SummarizedExperiment}(
  Y,
  X,
  V,
  K = 2,
  which_assay,
  commondispersion = TRUE,
  verbose = FALSE,
  maxiter_optimize = 100,
  stop_epsilon = 1e-04,
  children = 1,
  random_init = FALSE,
  random_start = FALSE,
  n_gene_disp = NULL,
  n_cell_par = NULL,
  n_gene_par = NULL,
  ...
)

\S4method{newFit}{matrix}(
  Y,
  X,
  V,
  K = 2,
  commondispersion = TRUE,
  verbose = FALSE,
  maxiter_optimize = 100,
  stop_epsilon = 1e-04,
  children = 1,
  random_init = FALSE,
  random_start = FALSE,
  n_gene_disp = NULL,
  n_cell_par = NULL,
  n_gene_par = NULL,
  ...
)

\S4method{newFit}{DelayedMatrix}(
  Y,
  X,
  V,
  K = 2,
  commondispersion = TRUE,
  verbose = FALSE,
  maxiter_optimize = 100,
  stop_epsilon = 1e-04,
  children = 1,
  random_init = FALSE,
  random_start = FALSE,
  n_gene_disp = NULL,
  n_cell_par = NULL,
  n_gene_par = NULL,
  ...
)

\S4method{newFit}{dgCMatrix}(Y, ...)
}
\arguments{
\item{Y}{The matrix with the data}

\item{...}{Additional parameters to describe the model, see
\code{\link{newmodel}}.}

\item{X}{The design matrix containing sample-level covariates, one sample per
row. If missing, X will contain only an intercept.}

\item{V}{The design matrix containing gene-level covariates, one gene
per row. If missing, V will contain only an intercept.}

\item{K}{integer. Number of latent factors(default 2).}

\item{which_assay}{numeric or character. Which assay of Y to use. If missing,
if `assayNames(Y)` contains "counts" then that is used. Otherwise, the
first assay is used.}

\item{commondispersion}{Whether or not a single dispersion for all features
is estimated (default TRUE).}

\item{verbose}{Print helpful messages(default FALSE).}

\item{maxiter_optimize}{maximum number of iterations for the optimization
step (default 100).}

\item{stop_epsilon}{stopping criterion in the optimization step,
when the relative gain in likelihood is below epsilon (default 0.0001).}

\item{children}{number of cores of the used cluster(default 1)}

\item{random_init}{if TRUE no initializations is done(default FALSE)}

\item{random_start}{if TRUE the setup of parameters is
a random samplig(default FALSE)}

\item{n_gene_disp}{number of genes used in mini-batch dispersion estimation
approach(default NULL > all genes are used)}

\item{n_cell_par}{number of cells used in mini-batch cell's related
parameters estimation approach(default NULL > all cells are used)}

\item{n_gene_par}{number of genes used in mini-batch gene's related
parameters estimation approach(default NULL > all genes are used)}
}
\value{
An object of class \code{newmodel} that has been fitted by penalized
 maximum likelihood on the data.
}
\description{
Given an object with the data, it fits a nb model.
}
\details{
By default, i.e., if no arguments other than \code{Y} are passed,
  the model is fitted with an intercept for the regression across-samples and
  one intercept for the regression across genes.

If Y is a Summarized experiment, the function uses the assay named
  "counts", if any, or the first assay.

Currently, if Y is a sparseMatrix, this calls the newFit method on
  as.matrix(Y)
}
\section{Methods (by class)}{
\itemize{
\item \code{SummarizedExperiment}: Y is a
\code{SummarizedExperiment}.

\item \code{matrix}: Y is a matrix of counts (genes in rows).

\item \code{DelayedMatrix}: Y is a DeleyedMatrix of counts (genes in rows).

\item \code{dgCMatrix}: Y is a sparse matrix of counts (genes in rows).
}}

\examples{
se <- SummarizedExperiment(matrix(rpois(60, lambda=5), nrow=10, ncol=6),
                           colData = data.frame(bio = gl(2, 3)))

m <- newFit(se, X=model.matrix(~bio, data=colData(se)))
bio <- gl(2, 3)
m <- newFit(matrix(rpois(60, lambda=5), nrow=10, ncol=6),
             X=model.matrix(~bio))
}
\seealso{
\code{\link[stats]{model.matrix}}.
}
