% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/helper_methods.R
\name{newBIC}
\alias{newBIC}
\alias{newBIC,newmodel,matrix-method}
\title{Compute the BIC of a model given some data}
\usage{
newBIC(model, x)

\S4method{newBIC}{newmodel,matrix}(model, x)
}
\arguments{
\item{model}{an object that describes a statistical model.}

\item{x}{an object that describes data.}
}
\value{
the BIC of the model.
}
\description{
Given a statistical model and some data, this function computes the BIC
of the model given the data, i.e., the BIC of the data under the model.
}
\section{Functions}{
\itemize{
\item \code{newBIC,newmodel,matrix-method}: returns the BIC of the NB model.
}}

\examples{
m <- newmodel(n=5, J=10)
x <- newSim(m)
newBIC(m, x$counts)
}
