% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netProcess.R
\name{reindexNetwork}
\alias{reindexNetwork}
\title{Replaces current vertex ids with chosen attribute.}
\usage{
reindexNetwork(graph, v.attr)
}
\arguments{
\item{graph}{An annotated igraph object.}

\item{v.attr}{Name of the attribute to use as vertex ids.}
}
\value{
A new graph with vertices expanded.
}
\description{
This function allows users to replace vertex ids with another attribute,
calculating connectivities based on the new attribute.
}
\details{
This functions can be very useful when merging networks constructed from different databases.
For example, to match a network created from Reactome to a KEGG network, you can reindex the
vertices by "miriam.kegg.compound" attribute. Another usage is to remove duplicated vertices (in case of
different subcellular compartments, for example). if a network has ATP_membrane & ATP_cytoplasm vertices,
reindexing by chemical name will collapse them into one `ATP` vertex.
}
\examples{
 ## Make a gene network from a reaction network.
 data(ex_sbml)	# A bipartite metbaolic network.
 rgraph <- makeReactionNetwork(ex_sbml, simplify=TRUE)
 ggraph <- makeGeneNetwork(rgraph)

 ## Expand vertices into their contituent genes.
 data(ex_kgml_sig)	# Ras and chemokine signaling pathways in human
	ggraph <- expandComplexes(ex_kgml_sig, v.attr = "miriam.ncbigene",
						keep.parent.attr= c("^pathway", "^compartment"))

 ## Create a separate vertex for each compartment. This is useful in duplicating
	##  metabolite vertices in a network.
\dontrun{
 graph <- expandComplexes(graph, v.attr = "compartment",
        keep.parent.attr = "all",
        expansion.method = "duplicate",
        missing.method = "keep")
}

}
\seealso{
Other Network processing methods: 
\code{\link{expandComplexes}()},
\code{\link{makeMetaboliteNetwork}()},
\code{\link{makeReactionNetwork}()},
\code{\link{rmSmallCompounds}()},
\code{\link{simplifyReactionNetwork}()},
\code{\link{vertexDeleteReconnect}()}
}
\author{
Ahmed Mohamed
}
\concept{Network processing methods}
