% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPath.R
\name{plotAllNetworks}
\alias{plotAllNetworks}
\title{Higlighting ranked paths over multiple network representations.}
\usage{
plotAllNetworks(
  paths,
  metabolic.net = NULL,
  reaction.net = NULL,
  gene.net = NULL,
  path.clusters = NULL,
  plot.clusters = TRUE,
  col.palette = palette(),
  layout = layout.auto,
  ...
)
}
\arguments{
\item{paths}{The result of \code{\link{pathRanker}}.}

\item{metabolic.net}{A bipartite metabolic network.}

\item{reaction.net}{A reaction network, resulting from \code{\link{makeReactionNetwork}}.}

\item{gene.net}{A gene network, resulting from \code{\link{makeGeneNetwork}}.}

\item{path.clusters}{The result from \code{\link{pathCluster}} or \code{\link{pathClassifier}}.}

\item{plot.clusters}{Whether to plot clustering information, as generated by \code{\link{plotClusters}}}

\item{col.palette}{A color palette, or a palette generating function (ex: \preformatted{col.palette=rainbow}).}

\item{layout}{Either a graph layout function, or a two-column matrix specifiying vertex coordinates.}

\item{...}{Additional arguments passed to \code{\link{plotNetwork}}.}
}
\value{
Highlights the path list over all provided networks.
}
\description{
This function highlighting ranked paths over different network representations, metabolic, reaction and
gene networks. The functions finds equivalent paths across different networks and marks them.
}
\examples{
	## Prepare a weighted reaction network.
	## Conver a metabolic network to a reaction network.
 data(ex_sbml) # bipartite metabolic network of Carbohydrate metabolism.
 rgraph <- makeReactionNetwork(ex_sbml, simplify=TRUE)

	## Assign edge weights based on Affymetrix attributes and microarray dataset.
 # Calculate Pearson's correlation.
	data(ex_microarray)	# Part of ALL dataset.
	rgraph <- assignEdgeWeights(microarray = ex_microarray, graph = rgraph,
		weight.method = "cor", use.attr="miriam.uniprot",
		y=factor(colnames(ex_microarray)), bootstrap = FALSE)

	## Get ranked paths using probabilistic shortest paths.
 ranked.p <- pathRanker(rgraph, method="prob.shortest.path",
					K=20, minPathSize=6)

plotAllNetworks(ranked.p, metabolic.net = ex_sbml, reaction.net = rgraph,
					vertex.label = "", vertex.size = 4)

}
\seealso{
Other Plotting methods: 
\code{\link{colorVertexByAttr}()},
\code{\link{layoutVertexByAttr}()},
\code{\link{plotClassifierROC}()},
\code{\link{plotClusterMatrix}()},
\code{\link{plotCytoscapeGML}()},
\code{\link{plotNetwork}()},
\code{\link{plotPathClassifier}()},
\code{\link{plotPaths}()}
}
\author{
Ahmed Mohamed
}
\concept{Plotting methods}
