% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netProcess.R
\name{makeMetaboliteNetwork}
\alias{makeMetaboliteNetwork}
\title{Convert metabolic network to metabolite network.}
\usage{
makeMetaboliteNetwork(graph)
}
\arguments{
\item{graph}{A metabolic network.}
}
\value{
A reaction network.
}
\description{
This function removes reaction nodes keeping them as edge attributes. The resulting
network contains metabolite nodes only, where edges indicate that reaction conversions.
}
\examples{
	## Conver a metabolic network to a metbolite network.
 data(ex_sbml) # bipartite metabolic network of Carbohydrate metabolism.
 mgraph <- makeMetaboliteNetwork(ex_sbml)

}
\seealso{
Other Network processing methods: 
\code{\link{expandComplexes}()},
\code{\link{makeReactionNetwork}()},
\code{\link{reindexNetwork}()},
\code{\link{rmSmallCompounds}()},
\code{\link{simplifyReactionNetwork}()},
\code{\link{vertexDeleteReconnect}()}
}
\author{
Ahmed Mohamed
}
\concept{Network processing methods}
