% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPath.R
\name{layoutVertexByAttr}
\alias{layoutVertexByAttr}
\title{A graph layout function, which groups vertices by attribute.}
\usage{
layoutVertexByAttr(
  graph,
  attr.name,
  cluster.strength = 1,
  layout = layout.auto
)
}
\arguments{
\item{graph}{An annotated igraph object.}

\item{attr.name}{The attribute name by which vertices are laid out.}

\item{cluster.strength}{A number indicating tie strengths between vertices with the same attribute.
The larger it is, the closer the vertices will be.}

\item{layout}{A layout function, ideally a force-directed layout fuction, such as
\code{\link[igraph]{layout_with_fr}} and \code{\link[igraph]{layout_with_kk}}.}
}
\value{
A two-column matrix indicating the x and y postions of vertices.
}
\description{
This function generates a layout for igraph objects, keeping vertices with the same attribute
(ex: in the same pathway, etc) close to each other.
}
\examples{
  data("ex_kgml_sig")
  v.layout <- layoutVertexByAttr(ex_kgml_sig, "pathway")
  plotNetwork(ex_kgml_sig, vertex.color="pathway", layout=v.layout)

  v.layout <- layoutVertexByAttr(ex_kgml_sig, "pathway", cluster.strength=5)
  plotNetwork(ex_kgml_sig, vertex.color="pathway", layout=v.layout)

}
\seealso{
Other Plotting methods: 
\code{\link{colorVertexByAttr}()},
\code{\link{plotAllNetworks}()},
\code{\link{plotClassifierROC}()},
\code{\link{plotClusterMatrix}()},
\code{\link{plotCytoscapeGML}()},
\code{\link{plotNetwork}()},
\code{\link{plotPathClassifier}()},
\code{\link{plotPaths}()}
}
\author{
Ahmed Mohamed
}
\concept{Plotting methods}
