% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netWeight.R
\name{getGeneSets}
\alias{getGeneSets}
\title{Generate genesets from an annotated network.}
\usage{
getGeneSets(graph, use.attr = "pathway", gene.attr = "genes", gmt.file)
}
\arguments{
\item{graph}{An annotated igraph object..}

\item{use.attr}{The attribute by which vertices are grouped (tepically pathway, or GO)}

\item{gene.attr}{The attribute listing genes annotated with each vertex (ex: miriam.ncbigene, miriam.uniprot, ...)}

\item{gmt.file}{Optinal. If provided, Results are exported to a GMT file. GMT files are readily used
by most gene set analysis packages.}
}
\value{
A list of genesets or written to gmt file if provided.
}
\description{
This function generates genesets based on a given netowrk, by grouping vertices sharing
common attributes (in the same pathway or compartment). Genes associated with each vertex
can be specified through \code{gene.attr} argument.
}
\examples{
 data(ex_kgml_sig)	# Ras and chemokine signaling pathways in human
 genesets <- getGeneSets(ex_kgml_sig, use.attr="pathway", gene.attr="miriam.ncbigene")


	# Write the genesets in a GMT file, and read it using GSEABase package.
 getGeneSets(ex_kgml_sig, use.attr="pathway", gene.attr="miriam.ncbigene", gmt.file="kgml.gmt")
 \dontrun{
	if(requireNamespace("GSEABase"))
		toGmt("kgml.gmt")
	}

	# Create genesets using compartment information
	data(ex_sbml) # bipartite metabolic network of Carbohydrate metabolism.
	genesets <- getGeneSets(ex_sbml, use.attr="compartment.name", gene.attr="miriam.uniprot")

}
\seealso{
\code{\link{getGeneSetNetworks}}
}
\author{
Ahmed Mohamed
}
