% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sampleData.R
\name{read_sampleData}
\alias{read_sampleData}
\title{Read in a sample data table.}
\usage{
read_sampleData(dat, file.name, idCol = NULL, groupCol, replicateCol = NULL)
}
\arguments{
\item{dat}{expression data, read in by read_merge_rcc or read.delim}

\item{file.name}{the path/name of the .txt or .csv file}

\item{idCol}{the column name of the sample identifiers in the sample table,
which should correspond to the column names in the count table 
(default NULL: will assume the first column contains the sample identifiers).}

\item{groupCol}{the column name of the group identifiers.}

\item{replicateCol}{the column name of the replicate identifiers (default
NULL). Multiple replicates of the same sample will have the same value in 
this column.}
}
\value{
The list with the expression data, now combined with the sample
information
}
\description{
Read in a .txt or .csv file containing sample names, group identifiers,
replicate identifiers, and any other sample data. Sample names must be in the
first column and must correspond with sample names in the count data file(s).
}
\examples{
example_data <- system.file("extdata", "GSE117751_RAW", package = "NanoTube")
sample_info <- system.file("extdata", "GSE117751_sample_data.csv", 
                           package = "NanoTube")

dat <- read_merge_rcc(list.files(example_data, full.names = TRUE))

# Merge expression data with sample info
dat <- read_sampleData(dat, file.name = sample_info,
                       groupCol = "Sample_Diagnosis")
}
