% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limmaToFGSEA.R
\name{limmaToFGSEA}
\alias{limmaToFGSEA}
\title{Run gene set enrichment analysis using DE results.}
\usage{
limmaToFGSEA(
  limmaResults,
  gene.sets,
  sourceDB = NULL,
  min.set = 1,
  rank.by = c("coefficients", "t"),
  skip.first = TRUE
)
}
\arguments{
\item{limmaResults}{Result from runLimmaAnalysis.}

\item{gene.sets}{Gene set file name, in .rds (list), .gmt, or .tab format;
or a list object containing the gene sets. Gene names must be
in the same form as in the ranked.list.}

\item{sourceDB}{Source database to include (only if using a .tab-format 
geneset.file from CPDB).}

\item{min.set}{Number of genes required to conduct analysis on a given gene 
set (default = 1). If fewer than this number of genes from limmaResults are 
included in a gene set, that gene set will be skipped for this analysis.}

\item{rank.by}{Rank genes by log2 fold changes ('coefficients', default) or 
t-statistics ('t').}

\item{skip.first}{Logical: Skip the first factor for gene set analysis?
Frequently the first factor is the 'Intercept', which is generally 
uninteresting for GSEA (default TRUE).}
}
\value{
A list containing data frames with the fgsea results for each 
comparison.
}
\description{
Use the fgsea library to run gene set enrichment analysis from the Limma
analysis results. Genes will be ranked by their log2 fold changes
or t-statistics (specified using 'rank.by').
}
\details{
Limma returns matrices of coefficients and t statistics with 
columns for each column in the design matrix. This function will conduct a
separate enrichment analysis on each column from the relevant matrix. Because
the first column may be an "intercept" term, which is generally not relevant
for enrichment analysis, the user may want to skip analysis for that term
(using skip.first = TRUE, the default).
}
\examples{
data("ExamplePathways")
data("ExampleResults") # Results from runLimmaAnalysis

# Use the default settings
fgseaResults <- limmaToFGSEA(ExampleResults, gene.sets = ExamplePathways)

# Only include gene sets with at least 5 genes in the NanoString data set,
# and rank genes by their "t" statistics.
fgseaResults <- limmaToFGSEA(ExampleResults, gene.sets = ExamplePathways,
                             min.set = 5, rank.by = "t")
}
