% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgseaToLEdge.R
\name{fgseaToLEdge}
\alias{fgseaToLEdge}
\title{Generate leading edge matrix from fgsea results.}
\usage{
fgseaToLEdge(
  fgsea.res,
  cutoff.type = c("padj", "pval", "NES", "none"),
  cutoff = 0.05,
  nes.abs.cutoff = TRUE
)
}
\arguments{
\item{fgsea.res}{Result from limmaToFGSEA}

\item{cutoff.type}{Filter gene sets by adjusted p-value ('padj'), nominal
p-value ('pval'), normalized enrichment score ('NES'), or include all gene
sets ('none')}

\item{cutoff}{Numeric cutoff for filtering (not used if 
cutoff.type == "none")}

\item{nes.abs.cutoff}{If cutoff.type == "NES", should we use extreme positive
and negative values (TRUE), or only filter in the positive or negative 
direction (FALSE). If TRUE, will select gene sets with abs(NES) > cutoff. 
If FALSE, will select gene sets with NES > cutoff (if cutoff >= 0) or
NES < cutoff (if cutoff < 0)}
}
\value{
a list containing the leading edge matrix for each comparison
}
\description{
Extract leading edge genes from gene sets identified in fgsea analysis.
Gene sets may be filtered by significance or NES.
}
\examples{
data("ExamplePathways")
data("ExampleResults") # Results from runLimmaAnalysis

fgseaResults <- limmaToFGSEA(ExampleResults, gene.sets = ExamplePathways)

# Generate the leading edge for pathways with padj < 0.25
leadingEdge <- fgseaToLEdge(fgseaResults, 
                            cutoff.type = "padj", cutoff = 0.25)

# Generate the leading edge for pathways with abs(NES) > 2
leadingEdge <- fgseaToLEdge(fgseaResults, cutoff.type = "NES",
                            cutoff = 2, nes.abs.cutoff = TRUE)
}
