% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_violin.R
\name{plot_violin}
\alias{plot_violin}
\title{Plot violin for regions}
\usage{
plot_violin(
  x,
  regions,
  binary_threshold = 0.5,
  group_col = "group",
  palette = ggplot2::scale_colour_brewer(palette = "Set1")
)
}
\arguments{
\item{x}{the NanoMethResult object.}

\item{regions}{a table of regions containing at least columns chr, strand,
start and end. Any additional columns can be used for grouping.}

\item{binary_threshold}{the modification probability such that calls with
modification probability above the threshold are considered methylated, and
those with probability equal or below are considered unmethylated.}

\item{group_col}{the column to group aggregated trends by. This column can
be in from the regions table or samples(x).}

\item{palette}{the ggplot colour palette used for groups.}
}
\value{
a ggplot object containing the methylation violin plot.
}
\description{
This function plots a violin plot of the methylation proportion for each region in the regions table. The methylation proportion is calculated as the mean of the modification probability wihtin each region and the violin represents the . The regions are then grouped and coloured by the group_col column in the regions table or samples(x).
}
\examples{
nmr <- load_example_nanomethresult()
gene_anno <- exons_to_genes(NanoMethViz::exons(nmr))
plot_violin(nmr, gene_anno)
plot_violin(nmr, gene_anno, group_col = "sample")

}
